/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets;

import com.badlogic.gdx.files.FileHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.guice.FloorDictionaryProvider;

@ProvidedBy(value=FloorDictionaryProvider.class)
@Singleton
public class FloorDictionary {
    private Map<Long, FloorType> floorTypeIdMap = new ConcurrentHashMap<Long, FloorType>();
    private Map<String, FloorType> floorTypeNameMap = new ConcurrentHashMap<String, FloorType>();
    private ObjectMapper objectMapper = new ObjectMapper();

    public FloorDictionary(FileHandle floorDefinitionsJsonFile) throws IOException {
        List floorTypes = (List)this.objectMapper.readValue(floorDefinitionsJsonFile.readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, FloorType.class));
        for (FloorType floorType : floorTypes) {
            if (this.floorTypeIdMap.containsKey(floorType.getFloorTypeId())) {
                throw new IOException("Duplicate floor for ID: " + floorType.toString());
            }
            this.floorTypeIdMap.put(floorType.getFloorTypeId(), floorType);
            this.floorTypeNameMap.put(floorType.getFloorTypeName().toLowerCase(), floorType);
        }
    }

    public FloorType getByFloorTypeId(long materialId) {
        return this.floorTypeIdMap.get(materialId);
    }

    public FloorType getByFloorTypeName(String name) {
        return this.floorTypeNameMap.get(name.toLowerCase());
    }

    public Collection<FloorType> getAllDefinitions() {
        return this.floorTypeNameMap.values();
    }
}

